"One way out" by Steffen Görzig

When play begins:
	say "You wake from sleep with a start. Your body is soaking in sweat, your heart is racing, your eyes are wide open. You are sitting upright and yet you do not know why. It's like this or similar every morning. You always wake with a start. There is no in-between world, no slow coming round, no pleasant state between sleeping and waking. You know nothing of dreams. You only know one thing: you're locked in, still. Captive in a large prison, an egg-shaped structure with high walls and without hope of escape. The wall is huge and not to be scaled. You know this for certain because you have spent years carefully examining every single section of the wall. The wall does not run straight, sometimes it appears to be stronger, sometimes weaker, but never weak enough for a serious frailty. Yet deep inside you there is still a little secret hope. A very small, very tiny spark of hope that gives you a little bit of strength. Just enough so that you can pick yourself up. And on rising your search for a way out, the one way out begins anew..."

[Tears filled his eyes. That was her narrative style, without a doubt. But the content! Friends had drawn his attention to this blog. With careful, sensitive words, they had asked him to take a look at this page, weeks later. Written by a blogger named 'Myfearlady'. 
She had never told him that every single one of her days began in such a terrible way. Of course he had noticed that she had woken from sleep with a start now and again. But she usually got up an hour earlier; his way to the office was much shorter. And what wall was she talking about? She had always assured him that she was happy! And he had never really restricted her, or had he? With a swift movement he wiped the tears from his eyes, looked back at the screen and read on.]

Chapter 1 - The frontal lobe

[Myfearlady World Construction]
The frontal lobe is a region.  The memory lapse is a door. It is southwest of the decidophobia and northeast of the amnesiphobia. The amnesiphobia is a dark room. The memory lapse is lockable and locked. The mnemonic device unlocks the memory lapse. The decidophobia and amnesiphobia are in the frontal lobe. The torch is in the decidophobia. The torch is lit. The safe is in the amnesiphobia. In the safe is the clef. The safe is closed and fixed in place.

[Myfearlady World Desciption]
The description of the decidophobia is "The fear of decision making. You have known it for some time. You were not exactly brought up to be independent, everything was decided for you. But today, it's even deciding on the right hair spray in the supermarket. The shelf is so long, the selection so great. You always have to accurately compare - prices, quantities, ingredients. Sweat stains form under your arms. And then just before you make your decision you realize that there are even differences in the effect on hair volume. Then the entire process of comparing starts over. In the end, you will have to do without hair spray."
The description of the amnesiphobia is "The fear of memory loss. It has only been with you for a little while. Naturally, it started out harmlessly. Sometimes you forgot where you had put your car keys, sometimes single items when shopping. Then there were names of individuals and entire events. Not that you had really forgotten them, just that you were not able to remember them immediately when needed. As if the way to them had been blocked, the information locked up in a safe and the combination lost. In the end you are actually afraid to go out into the world and meet people. They might greet you and perhaps you would not be able to answer, because the safe was locked up once more at that moment. Even though you were among the best at school and later at university, part of the elite. And that not because you were really that good but because you could remember everything effortlessly and recall it during tests as a matter of course."
The description of the torch is "A torch, its flame burning bright. A little too bright and long lasting for this small piece of wood. Its strange shimmering light gives the impression of penetrating clarity wherever it shines." 
The description of the safe is "A tightly sealed safe. It appears to be a fairly new model." 

[Myfearlady World Rules]
Instead of opening the safe, say "The safe opens only when turned to the correct combination." 
Spinning it to is an action applying to one thing and one number. Check spinning it to: if the noun is not the safe, say "[The noun] does not spin." instead. Report spinning it to: say "Click! Nothing else happens." 
Understand "spin [something] to [a number]" as spinning it to. 
After spinning the closed safe to 1337: now the the safe is open; say "With a click as if from far away, the safe door swings open, revealing [a list of things in the safe]." 

[He sat there, completely upset and confused. What kind of a strange language had she chosen there? So formal and seemingly without any real connection. And what fears was she talking of? She had always chosen everything. She had decided every little part of their life together, up to the smallest, even most insignificant detail. Decorative stones in glass containers - her idea! And if anyone could not remember things, then surely it was he! He even had to ask her for his own mobile number on many occasions. So what did it all mean, what did it have to do with her?]

Chapter 2 - The parietal lobe

[Myfearlady World Construction]
The parietal lobe is a region. The algophobia is east of the decidophobia. The claustrophobia is east of the algophobia. The algophobia and claustrophobia are in the parietal lobe. The window is a door. It is southeast of the claustrophobia and northwest of the catoptrophobia.  The bed is a thing in the claustrophobia. It is fixed in place, a supporter, enterable and pushable between rooms. The cassette recorder is a device in the algophobia. It is fixed in place.

[Myfearlady World Desciption]
The description of the algophobia is "The fear of pain. You cannot remember ever being beaten by your parents. On the contrary, they have always protected you from everything and kept you isolated. Once you had been stung by a bee, when you were running barefoot through a meadow. Then your mother first blamed you, then herself and then she was crying with you. Since then you have avoided going barefoot and started gagging at the smell of honey."
The description of the claustrophobia is "The fear of enclosed spaces. It began with journeys on buses that were always overcrowded. As soon as the doors closed behind you, your anxieties would start. Your heart was racing, your breathing was labored. In addition there was a surge of unpleasant human odors, which made breathing completely impossible. Then the sudden urge to flee, combined with burgeoning panic because the escape route was blocked. Just like being buried alive."
The description of the cassette recorder is "[if switched on]There is a crackle. Your own voice sounds grainy and tinny from the speaker: 'Scientific Elite, record number 1337 - memory. Memory consists of the stored information itself and the access to it. If one of them is missing, memory is lost.'[otherwise]The device appears to be attached to the ceiling in some way.[end if]".
The description of the bed is "A dusty old hospital bed. It looks as if it has not been used in a long time."
The description of the window is "Through the window, you make out [the other side of the window]."

[Myfearlady World Rules]
Instead of switching on cassette recorder when the player is not on the bed:
	say "It's suspended too high, you cannot get to it."
Instead of climbing the window: 
	try entering the window. 

[He leaned back, took a deep breath and tried to bring order into his emotional chaos. She had created her own world that much he had understood. A world full of fear and suggestion. Much was obvious, some of it consisted of encrypted images. It was not clear to him what connection there was between this world and reality. In doing so she had used a rather cryptic language which, nevertheless, seemed at the same time to be very clear and unambiguous. Quite the scientist. At that thought, he shook his head and could not help a small smile. Then he went on reading.]

Chapter 3 - The occipital lobe

[Myfearlady World Construction]
The occipital lobe is a region. The scopophobia is south of the catoptrophobia. The catoptrophobia and scopophobia are in the occipital lobe. Worst nightmare is a man in the claustrophobia. The sound curtain is a door. It is west of the scopophobia and east of the peladophobia. The sound curtain is lockable and locked. The clef unlocks the sound curtain.

[Myfearlady World Desciption]
The description of the catoptrophobia is "The fear of mirrors. It only comes at night. Then when you look into a mirror, it seems to you that you can glimpse a parallel world behind it. This world is similar to ours just that it is reversed and everything also seems to be a bit darker and duller. It's a silent world, though an image appears a sound is never heard from there. You know you will be drawn into this world, if you get too close to the mirror. And you know that this journey can only go in one direction, there is no way back."
The description of the scopophobia is "The fear of being stared at. You avoid the gaze of others. Nevertheless, you feel certain that they are watching you behind your back. These people disapprove of everything you do or say. Of course they do not say it openly, on the contrary they often smile at you. Only a tiny sparkle in the corner of their eyes betrays them all."
The description of the sound curtain is "A curtain woven from individual sounds. It moves constantly and in doing so produces numerous fragments of music, sometimes a gentle chime, and then loud trumpet fanfare."

[Myfearlady World Rules]
Every turn:
	if the location of worst nightmare is a room:
		if the location of worst nightmare is not the location of the player:
			let the way be the best route from the location of worst nightmare to the location of the player, using doors;
			try worst nightmare going the way;
		otherwise:
			say "Your worst nightmare is standing before you! He is strangely shapeless, then turns into a vicious predator with sharp teeth and a vertiginous abyss for a throat. Your heart skips a beat. 'At last I've found you,' he says in a shaky voice."
Instead of examining worst nightmare:
	say "You stand up to your worst nightmare! With each step up to him, he becomes smaller, visibly losing color and shape. Then he begins to completely dissolve into smoke. The smoke still wafts around for a while, finally blows away and reveals an object to view."; 
	now the mnemonic device is in the location;
	remove worst nightmare from play.

[What was it again, the occipital lobe? And the frontal and parietal lobe? He opened another window in the browser and entered the search term 'human brain'. He had numerous hits, scanned over the most promising ones, found a summary suitable for him and spoke softly to himself while reading.]

Chapter 4 - The temporal lobe

[Myfearlady World Construction]
The temporal lobe is a region. The phonophobia  is west of the peladophobia. The peladophobia and phonophobia  are in the temporal lobe. The rope bridge is southeast of the phonophobia  and northwest of the kinesiophobia. The rope bridge is an open unopenable door. Lecture is a scene. Lecture begins when the player is in the phonophobia  for the first turn.

[Myfearlady World Desciption]
The description of the peladophobia is "The fear of bald individuals. At the mere sight of bald individuals you feel sick and start to run. You only need to look at 'Mr.  Clean' and immediately require his help to clean up the floor again."
The description of the phonophobia  is "The fear of noise and sounds. When you were a child, youths set off fireworks right next to your ear. Since then you have been strictly avoiding all noisy places. If man could but close his ears!"
The description of the rope bridge is "The rope bridge consists of only one rope and is extremely fragile and precarious."

[Myfearlady World Rules]
When Lecture begins:
	say "You hear a voice that seems strangely familiar to you and which immediately attracts your attention. It appears to read out something, to you or only to itself."
Every turn during Lecture:
	repeat through Table of Lecture Events:
		say "[event entry][paragraph break]";
		blank out the whole row;
		rule succeeds.
Instead of doing anything other than waiting, looking or listening during Lecture:
	say "The voice is to intense that you are frozen into inaction.";
	
Lecture ends when the number of filled rows in the Table of Lecture Events is 0.
When Lecture ends:
	say "You feel hot and cold at the same time. You'd almost fallen asleep during this boring lecture. But then at the end, right at the end, out of nowhere came the decisive clue! The clue as to how you can escape from the prison! Is there a way out after all?"
Instead of going through the rope bridge when the player is carrying something:
	say "You step carefully onto the rope which is stretched under your weight and creaking dangerously. You turn around immediately. Obviously you are carrying too much ballast around with you.";
	stop the action.
After going through the rope bridge:
	say "You feel free and weightless! You balance on the rope without uncertainty.";
	continue the action.
	
[Myfearlady World Events]
Table of Lecture Events
event
"'Broadly speaking, the human brain can be divided into the frontal, parietal, occipital and temporal lobes, the cerebellum and brain stem.'"
"'The frontal lobe is the seat of higher mental abilities. Following damage to the frontal lobe disorders of memory capacity or an adherence to irrelevant details may arise - thus here lies the link to fear of memory loss and fear of decisions.'"
"'The parietal lobe contains the central processing area for haptic perception, triggered initially by millions of sensory cells that respond to pressure or pain-inducing stimuli. It also plays a key role in spatial awareness - which explains the fears of pain and confined spaces.'" 
"'The occipital lobe contains the visual cortex and mainly processes optical stimuli - thus the fear of mirrors and being stared at is connected to it thematically.'"
"'The temporal lobe contains the auditory centre and is involved in the recognition of faces - which fears might be described here?'"
"'Well, then there's the cerebellum. It regulates movement and is important for maintaining balance.'"
"'Finally, there is the brain stem: it contains, among other things, the centers for controlling blood circulation, respiration as well as vomiting. A failure of the brain stem, such as due to an injury to the cervical spine, usually leads to death.'"

[He sat there with his mouth open: thus she had foreseen that he would look it up and that, as always, he would softly talk to himself and had built this into her blog. And at the right moment and on the bit about the area of the brain, which is responsible for listening. He felt real, deep admiration for her. A bridge between two worlds, so to speak. Admittedly, he had found divergent descriptions, basically however, it fit quite well. Suddenly it annoyed him that she had not trusted him to grasp the connections earlier. Sulking a little he continued to read.]

Chapter 5 - The cerebellum

[Myfearlady World Construction]
The cerebellum is a region. The kinesiophobia is in the cerebellum.

[Myfearlady World Desciption]
The description of the kinesiophobia is "The fear of movement. 'Not another step' your body seems to scream from every pore. The situation is already unbearable but you know that every further step will inevitably lead to disaster."

[He had another suspicion. He turned to the printer and took out a piece of white paper from the tray. Then he took a pen and labeled the edges of each paper centrally. He drew a rectangle on the bottom right and labeled it. He read the blog from the beginning and then looked at the paper. He sighed, crumpled up the paper, took a new sheet from the printer, labeled the edges once more and this time he drew the rectangle in the middle of the paper. He scanned back over the part of the blog he had already read and added lines, rectangles and labels to the sheet from time to time. In the end, he drew an egg-shaped outline around all of the rectangles. He held the outcome up in the air: it was a map, a map of the brain. Constructed according to the information contained in the blog under 'Myfearlady World Construction'. It showed the broad division of the human brain when viewed from the side.]

Chapter 6 - The brain stem

[Myfearlady World Construction]
The brain stem is a region. The acrophobia is above the kinesiophobia. The acrophobia is in the brain stem.

[Myfearlady World Desciption]
The description of the acrophobia is "Fear of heights. An abyss draws you like a magnet. It whispers to you, that you can fly. And among the whispered words there are soft whispers of redemption."

[Myfearlady World Rules]
Before going to the acrophobia:
	say "You feel sick, your circulation threatens to collapse, and each step becomes a torment. But you carry on climbing up, further and further upwards. The evening wind is blowing and the sun is setting. The moon rises and casts the scene in a pale light, the stars are shining in the sky. But behind these stars is darkness. Pitch black, impenetrable darkness. But you, you climb on and on ..."
Before going from the acrophobia:
	say "You run down and with each step, your heart feels freer. And lo and behold, the sun is rising, the sun!"
Instead of jumping in acrophobia: end the story finally;

[He knew exactly what would be coming. And she had even put the clue to the ending into his mouth herself! Annoyance and indignation came over him and immediately vanished once more. Hesitantly he continued reading.]

Chapter 7 - The End

When play ends: 
	say "You step up to the abyss, muster all your courage. You take a last deep breath in. Then you jump. Suddenly in flight you see your prison with clarity before you, almost as oval as an egg. You think of freedom, freedom from this prison, freedom from your fears, freedom from all the troubles of life. You feel weightless and an effervescent feeling of happiness comes over you: you know you've done it, you have reached your goal! Since your objective is the end and at the end there is nothing, not even silence."

[This was the last blog entry. According to the date given it was written a few weeks ago. Motionless, he kept on staring at the screen, as if he hoped to discover a new entry shortly. Yet this new entry remained elusive, after ten seconds, three minutes and countless hours. The night crept through the window and bathed everything in darkness, only dispelled here and there by the cold light of the screen. With a start, he awoke from his torpor. He stood up, walked over to the window and opened it. The fresh evening air hit him without effect, he did not notice the noise from the street below him. His gaze travelled to the horizon, concentrating and focusing hard, as if he hoped to see something there. A wall maybe. Suddenly, he stepped close to the window, right in front of the abyss. He took a last deep breath and closed his eyes. Then he opened them again, locked the window, shut down the computer, left the room with long strides and pulled the door firmly shut behind him.]


